
# common.mk : Common makefile for building tex documents.  Tested to
# work fine with tools from a default cygwin installation.
#
# This file should be included at the end of a top-level makefile that
# defines:
#
#   NAME      - the name of the main tex file (becomes name of output)
#   TEXFILES  - list of tex files constituting document
#   BIBFILE  -  bib file for document
%.SUFFIXES: graphs/%.plot graphs/%.eps png/%.png figs/%.eps
.SUFFIXES: png/%.png figs/%.eps

ifndef MAIN_TEXFILE
$(error No main tex file specified)
endif

ifndef BIBFILE
$(error No bib file specified)
endif

NAME = $(basename $(MAIN_TEXFILE))

TEXFILES = $(MAIN_TEXFILE) $(OTHER_TEXFILES)

GNUPLOTFILES = $(filter graphs/%.plot,$(GRAPHFILES))
JGRAPHFILES  = $(filter graphs/%.jgr,$(GRAPHFILES))

GNUPLOT2EPS = $(patsubst graphs/%.plot,graphs/%.eps,$(GNUPLOTFILES))
JGRAPH2EPS  = $(patsubst graphs/%.jgr,graphs/%.eps,$(JGRAPHFILES))

PNGFILES = $(wildcard png/*.png)
PNG2EPS  = $(patsubst png/%.png, png/%.eps, $(PNGFILES))

EPS_FIGURES = $(wildcard figs/*.eps)

PDFLATEX_FLAGS = "--shell-escape"


all: $(NAME).pdf

$(NAME).pdf: $(JGRAPH2EPS) $(GNUPLOT2EPS) $(PNG2EPS) $(TEXFILES) $(BIBFILE) $(EPS_FIGURES)
	latex $(NAME)
	bibtex $(basename $(BIBFILE))
	latex $(NAME)
	pdflatex ${PDFLATEX_FLAGS} $(NAME)

clean:
	rm -rf *.aux *.bbl *.log *.dvi *.pdf *.blg *.ps *.bak *~ *.toc $(NAME).pdf 
	rm -rf $(GNUPLOT2EPS) $(JGRAPH2EPS) $(PNG2EPS) graphs/*~

spell: $(SPELL)

%.spell:
	aspell check $*

%.eps: %.jgr
	@echo "Running jgraph on $<"
	@jgraph $< > $@

png/%.eps: png/%.png
	@echo "Converting $< to $@"
	@convert $< $@

graphs/%.eps: graphs/%.plot
	@echo "Running gnuplot on $<"
	@cd graphs/; gnuplot $(notdir $<)
