#include <stdlib.h>
#include <stdio.h>
#include <QApplication>

#include <sys/types.h>
#include <sys/stat.h>

#include "MyCamera.h"

int main(int argc, char ** argv) {

  QApplication app(argc, argv);

  if (argc > 1) {
    char* dirPath = argv[1];
    if (access(dirPath, F_OK)) {
      mkdir(dirPath, S_IRWXU);
    }
    if (chdir(dirPath) != 0) {
      fprintf(stderr, "couldn't chdir to %s\n", dirPath);
    }
  }


  // This is the main workhorse. See MyCamera.h/cpp.
  MyCamera m;

  /* A complex camera application will typically 
   * necessitate multiple threads.
   * (One thread handles the UI events; another thread
   *  handles viewfinder streaming, et cetera.)
   */

  /* Show the widget on the screen. */
  m.showFullScreen();

  /* Tell the camera to start streaming. Internally,
   * this launches a new thread.
   */
  m.startStreaming();

  /*
   * The current thread will start the event loop.
   * app.exec() then blocks until the application is done.
   */
  return app.exec();
}
