#ifndef __GL_SHAPES_H__
#define __GL_SHAPES_H__

#include "geom.h"

#include <QtOpenGL>
#include <QGLWidget>

static const int POS_ATTR = 0;
static const int COL_ATTR = 1;

inline void
DrawBox(const BBox2s& box)
{
  const Vec2s& bl = box.bmin;
  const Vec2s& tr = box.bmax;
  Vec2s tl(bl[0], tr[1]);
  Vec2s br(tr[0], bl[1]);

  static const int numLines = 4;
  static const int numPoints = numLines*2;
  Vec2s lines[numPoints] = {
    bl, br,
    br, tr,
    tr, tl,
    tl, bl
  };
  glVertexAttribPointer(POS_ATTR, 2, GL_SHORT, GL_FALSE, sizeof(Vec2s), lines); 

  glEnableVertexAttribArray(POS_ATTR);
  glDrawArrays(GL_LINES, 0, numPoints);
  glDisableVertexAttribArray(POS_ATTR);
}

#endif //__GL_SHAPES_H__
