#ifndef __GEOM_H__
#define __GEOM_H__

#include <limits>

class Vec2s
{
  public:
    short p[2];
    inline Vec2s() { /*p[0]=0.0; p[1]=0.0;*/ }
    inline Vec2s(short x, short y) { p[0]=x; p[1]=y; }
    inline Vec2s(const short *f) { p[0]=f[0]; p[1]=f[1]; }
    inline Vec2s(const Vec2s& v) { p[0]=v.p[0]; p[1]=v.p[1]; }
    inline void setValue(short x, short y) { p[0]=x; p[1]=y; }
    inline short* getValue() { return p; }
    inline const short* getValue() const { return p; }
    inline void set(short *f) { p[0]=f[0]; p[1]=f[1]; }
    inline void scale(short s) { p[0]*=s; p[1]*=s; }
    inline void negate() { p[0]=-p[0]; p[1]=-p[1]; }
    inline short& operator[](short n)
    { return p[n]; }
    inline const short& operator[](short n) const
    { return p[n]; }
    inline Vec2s operator+(const Vec2s &v) const
    { return Vec2s(p[0]+v.p[0], p[1]+v.p[1]); }
    inline Vec2s operator-(const Vec2s &v) const
    { return Vec2s(p[0]-v.p[0], p[1]-v.p[1]); }
    inline Vec2s operator-() const
    { return Vec2s(-p[0], -p[1]); }
    inline Vec2s operator*(short f) const
    { return Vec2s(p[0]*f, p[1]*f); }
    inline Vec2s operator/(short f) const
    { return Vec2s(p[0]/f, p[1]/f); }
    inline Vec2s& operator+=(const Vec2s& v)
    { p[0]+=v.p[0]; p[1]+=v.p[1]; return *this; }
    inline Vec2s& operator*=(short f)
    { p[0]*=f; p[1]*=f; return *this; }
    inline Vec2s& operator/=(short f)
    { p[0]/=f; p[1]/=f; return *this; }
    inline bool operator==(const Vec2s &v) const
    { return p[0]-v.p[0] == 0 && p[1]-v.p[1] == 0; }
    inline short dot(const Vec2s &v) const
    { return p[0]*v.p[0] + p[1]*v.p[1]; }
    inline short cross(const Vec2s &v) {
      return p[0]*v.p[1] - p[1]*v.p[0];
    }
};

struct BBox2s {
  Vec2s bmin, bmax;

  BBox2s() {
    Reset();
  }

  inline void Reset() {
    bmin[0] = bmin[1] = std::numeric_limits<short>::max();
    bmax[0] = bmax[1] = std::numeric_limits<short>::min();
  }

  inline bool Contains(const Vec2s& p) {
    return bmin[0] <= p[0] && bmax[0] >= p[0]
      && bmin[1] <= p[1] && bmax[1] >= p[1];
  }

  inline bool Empty() const {
    return (bmin[0] >= bmax[0]) || (bmin[1] >= bmax[1]);
  }
};

class Matrix
{
  private:
    float matrix[4][4];

  public:
    Matrix() {}
    Matrix(const float* data) {
      for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
          matrix[i][j] = data[4*i+j];
        }
      }
    }
    Matrix(const float data[4][4]) {
      for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
          matrix[i][j] = data[i][j];
        }
      }
    }

    inline float* operator [](int i) { return &matrix[i][0]; }
    inline const float* operator [](int i) const  { return &matrix[i][0]; }

    Matrix& operator*=(float f) {
      for (int i=0; i<4; i++)
        for (int j=0; j<4; j++)
          matrix[i][j] *= f;
      return *this;
    }

    inline void zero() {
      for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
          matrix[i][j] = 0.f;
        }
      }
    }

    inline const float* getValue() const { return &(matrix[0][0]); }
    inline float* getValue() { return &(matrix[0][0]); }

    static void Ortho2D(Matrix& m, float l, float r, float b, float t) {
      float f = 1.f;
      float n = -1.f;

      float len[3] = {
        r - l, 
        t - b, 
        f - n
      }; 

      float trans[3] = {
        -(r + l) / len[0],
        -(t + b) / len[1],
        -(f + n) / len[2]
      };

      m.zero();

      for (int i = 0; i < 3; i++) {
        m.matrix[i][i] = 2.f / len[i];
        m.matrix[3][i] = trans[i];
      }

      m.matrix[3][3] = 1.f;
    }

    static void Identity(Matrix& m) {
      m.zero();
      m.matrix[0][0] = 1.f;
      m.matrix[1][1] = 1.f;
      m.matrix[2][2] = 1.f;
      m.matrix[3][3] = 1.f;
    }
};


#endif //__GEOM_H__
