#ifndef _MYVIEWFINDERX_H_
#define _MYVIEWFINDERX_H_

#include "geom.h"

#include <QWidget>
#include <QX11Info>
#include <QMouseEvent>

#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/XShm.h>
#include <X11/extensions/Xv.h>
#include <X11/extensions/Xvlib.h>
#include <FCam/Image.h>

#define X_UYVY 0x59565955

/*
 * A screen overlay widget that MyCameraThread
 * can draw frames onto.
 */
class MyViewfinderX : public QWidget {
  Q_OBJECT; // Insert this if custom slots/signals are used.
 public:

  /* Constructor */
  MyViewfinderX(QWidget *parent = 0);

  /* This widget draws directly on the screen using libXv,
   * which means drawing on top of viewfinder frames is difficult.
   * A workaround is using a color key. The widget will avoid
   * overwriting screen pixels that match the color key.
   * Hence, one could put a widget underneath the viewfinder,
   * and it will "show" through.
   */
  /* Returns the color key of the widget */
  static QColor colorKey() {return QColor(0, 0, 0);}
  
  /* Returns the frame buffer used by the widget */
  FCam::Image getFrameBuffer(int w, int h);

 signals:
  void mouseReleased(int x, int y);
  void mouseMoved(int x, int y);

 protected:
  void mouseReleaseEvent(QMouseEvent * e) {
    // Emit a signal
    emit mouseReleased(e->x(), e->y());
  }

  void mouseMoveEvent(QMouseEvent * e) {
    // Emit a signal
    emit mouseMoved(e->x(), e->y());
  }
  void paintEvent(QPaintEvent * e);

 private:

  /* Internal routines for dealing with libXv */
  void checkImageSize(int w, int h);
  void initXv();

  XShmSegmentInfo yuv_shminfo;
  GC gc;
  int xv_port;
  Display * dpy;
  
  // two different ways to refer to the same data
  XvImage * m_yuv_image;
  FCam::Image m_framebuffer;
};

#endif
