#include "MyViewfinderX.h"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>

MyViewfinderX::MyViewfinderX(QWidget *parent) : QWidget(parent)  {

  /* Open an xv port */
  initXv();
  
  /* Make QT do the work of keeping the overlay the magic color */   
  QWidget::setBackgroundRole(QPalette::Window);
  QWidget::setAutoFillBackground(true);
  QPalette overlayPalette = QWidget::palette();
  overlayPalette.setColor(QPalette::Window, colorKey());  
  QWidget::setPalette(overlayPalette);
}

void MyViewfinderX::initXv() {

  unsigned int nAdaptors;
  XvAdaptorInfo *ai;
  
  xv_port = -1;
  dpy = x11Info().display();
  XvQueryAdaptors(dpy, winId(),&nAdaptors, &ai);     
  if (nAdaptors > 0) {
    xv_port = ai[0].base_id; // Use the last available port
    fprintf(stderr, "MyViewfinderX : Using port %d.\n", xv_port);
    XvFreeAdaptorInfo(ai);
  } else {
    fprintf(stdout, "MyViewfinderX: no available xv ports.\n"); 
    return;
  }  
  gc = XCreateGC(dpy, winId(), 0, 0);		  
  m_yuv_image = NULL;
  QColor key = colorKey();
  int val = ((key.red() >> 3) << 11) | ((key.green() >> 2) << 5) | ((key.blue() >> 3));
  XvSetPortAttribute(dpy, xv_port, XInternAtom(dpy, "XV_COLORKEY", True), val);

}

FCam::Image MyViewfinderX::getFrameBuffer(int w, int h) {
    checkImageSize(w, h);
    return m_framebuffer;
}

void MyViewfinderX::checkImageSize(int w, int h) {
  if (m_yuv_image == NULL ||
      w != m_yuv_image->width ||
      h != m_yuv_image->height) {    
    fprintf(stderr, "MyViewfinderX : Creating new image\n"); fflush(stderr);
       
    /* shared-memory mode */
    XFree(m_yuv_image);
    m_yuv_image = XvShmCreateImage(dpy, xv_port, X_UYVY, 0, w, h, &yuv_shminfo);
    if (!m_yuv_image) {
      fprintf(stderr, "MyViewfinderX : XvShmCreateImage returned NULL\n");
      return;
    }
    yuv_shminfo.shmid = shmget(IPC_PRIVATE, m_yuv_image->data_size, IPC_CREAT | 0777);
    yuv_shminfo.shmaddr = m_yuv_image->data = (char *)shmat(yuv_shminfo.shmid, 0, 0);
    yuv_shminfo.readOnly = False;
    
    m_framebuffer = FCam::Image(w, h, FCam::UYVY, (unsigned char*)m_yuv_image->data);
    
    if (!XShmAttach(dpy, &yuv_shminfo)) {
      fprintf(stderr, "MyViewfinderX : XShmAttach failed!\n");
      return;
    }      		      
  }    
}

void MyViewfinderX::paintEvent(QPaintEvent * event) {
  if (m_yuv_image)
    XvShmPutImage(dpy, xv_port, winId(), gc, m_yuv_image,
		  0, 0, m_yuv_image->width, m_yuv_image->height,
		  0, 0, width(), height(), false);
}

