#ifndef _MYINFOWIDGET_H_
#define _MYINFOWIDGET_H_

#include "MyCamera.h"
#include "geom.h"

#include <QtOpenGL>
#include <QGLWidget>
#include <FCam/Event.h>
#include <FCam/Frame.h>

class MyViewfinderX;

/* A GL widget that sits on top of the viewfinder
 * and can draw things on top of it, such as
 * autofocus points, histograms, crosshairs, feature points, etc.
 */
class MyInfoWidget : public QGLWidget, public FCam::EventGenerator {
  Q_OBJECT;
  public:

  /* Constructor */
  MyInfoWidget(MyViewfinderX * parent, ShotMode mode, int numRings, int spotsPerRing);

  /* Takes a frame and displays pertinent info on screen */
  void processFrame(FCam::Frame::Ptr f);

  std::string getEventString( const FCam::Event& ev) const {
    return std::string("MyInfoWidget: ") + ev.description();
  }

  void setShotMode(ShotMode mode) {
    m_shotMode = mode;
  }

  public slots:
    void viewfinderMouseMove(int x, int y);

  protected:
    void paintGL();

  private:
    // Create OpenGL shader obj.
    void createProgramObject();

    FCam::Frame::Ptr m_frame; 
    int m_programObject; // for OpenGL
    GLint m_projMatrixLoc, m_mvMatrixLoc;

    struct HotSpotElem {
      BBox2s box;
      bool visited; // not sure what i'm gonig to use this for yet
    };
    std::vector<HotSpotElem> m_hotSpots;

    bool isOverHotSpot(int x, int y, int& which);

    void DrawHotSpots() const;

    ShotMode m_shotMode;
};

#endif
