#ifndef _MYCAMERATHREAD_H_
#define _MYCAMERATHREAD_H_

#include <QThread>
#include <QObject>
#include "MyInfoWidget.h"
#include "MyViewfinderX.h"

#include <FCam/N900/Flash.h>
#include <FCam/N900/Lens.h>
#include <FCam/N900/Sensor.h>
#include <FCam/N900/ButtonListener.h>
#include <FCam/Event.h>

#include <cmath>
#include <stdio.h>

#define TAKE_FRAMES 0

/*
 * This class is responsible for
 * streaming images from the sensor.
 */
class MyCameraThread : public QThread {
  Q_OBJECT; // Include this line if you use signals/slots.

 public:

  /* Constructor
   *
   * The first argument is the viewfinder widget
   * to which frames should be sent.
   */
  MyCameraThread(MyViewfinderX * viewfinder,
		 MyInfoWidget * infowidget,
		 QObject * parent = 0);

  /* Destructor */
  ~MyCameraThread();
  
 public slots:
  // Schedule the thread to terminate, if it is running.
  void scheduleTermination() {
    fprintf(stderr, "MyCameraThread : scheduling termination.\n");
    m_terminate = true;
  }

  // Serve a request to focus at min/max
  void focusNear() { m_lens.setFocus(m_lens.nearFocus(), -1); }
  void focusFar() { m_lens.setFocus(m_lens.farFocus(), -1); }

  void setShotModeStream() { setShotMode(Stream); }
  void setShotModeSpots() { setShotMode(HotSpot); }

  /* Set the exposure (0 ~ 100) level, and returns
   * the # of microseconds decided upon. The level
   * is interpreted to be on a log scale.
   */
  int exposureChanged(int level);

 protected:

  /* Launch the thread */
  void run();

 private:

  void setShotMode(ShotMode mode) {
    m_shotMode = mode;
    m_infowidget->setShotMode(mode);
    m_infowidget->update();
  }

  MyViewfinderX * m_viewfinder;
  MyInfoWidget * m_infowidget;

  static const int kMaxNumStream = 32;
  ShotMode m_shotMode;

  bool m_terminate;
  bool m_exposureUpdated;

  FCam::Shot m_shot; // for streaming
  FCam::Shot m_snapshot; 

  FCam::N900::Lens m_lens;

};

#endif
