#ifndef _MYCAMERA_H_
#define _MYCAMERA_H_

#include <QtGui>

class MyCameraThread;

typedef enum {
  HotSpot,
  Stream
} ShotMode;

/*
 * A UI widget which demonstrates basic interaction
 * with the onboard camera.
 */
class MyCamera : public QWidget {
  Q_OBJECT; // Include this line if you use signals/slots.
  
 public:

  /* Constructor */
  MyCamera(QWidget * parent = 0);

  /* Destructor */
  ~MyCamera();

  /* Launches a thread to stream frames */
  void startStreaming();

  typedef enum {
    CaptureHighRes = -1,
    CaptureLoRes = -2
  };

 public slots:
  /* Terminates the application */
  void scheduleTermination();

 private:
  // A thread that streams frames
  MyCameraThread * m_thread;

  // UI elements
  QPushButton * m_exit;
  QPushButton * m_mode_stream;
  QPushButton * m_mode_spot;
  QSlider * m_exposure_slider;
};


#endif
