#ifndef __GL_STRING_H__
#define __GL_STRING_H__

#include "platform.h"

#include <iostream>
#include <string>

#include <ctype.h>

static const float kGlyphHeight = 119.05f;
static const float kGlyphWidth = 104.76f;

static inline float
ComputeTextStringWidth(const char* str, float fontHeight) {
  return (fontHeight / kGlyphHeight) * kGlyphWidth * strlen(str);
}

// returns the width
inline float
glDrawText(float x, float y, const char* str, float fontHeight)
{
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glEnable(GL_BLEND);
  glEnable(GL_LINE_SMOOTH);

  glPushMatrix();
  {
    glTranslatef(x, y, 0);

    float scale = fontHeight / kGlyphHeight;
    glScalef(scale, scale, 1.f);

    const char* c;
    for (c = str; *c != '\0'; c++)
      glutStrokeCharacter(GLUT_STROKE_MONO_ROMAN, *c);
  }
  glPopMatrix();

  glDisable(GL_BLEND);
  glDisable(GL_LINE_SMOOTH);

  return ComputeTextStringWidth(str, fontHeight);
}

#endif // __GL_STRING_H__
