#ifndef __GL_SHAPES_H__
#define __GL_SHAPES_H__

#include "platform.h"

#include <core/geom.h>

#include <math.h>

/**
 * function: draws a circle with the given radius.
 */
inline void
glCirclef(float radius, int nSegs = 180)
{
  // TODO: all sorts of optimizations could be made here
  float k = 2.f * M_PI / nSegs;
  glPushMatrix(); {
    glScalef(radius, radius, 1.f);
    glBegin(GL_LINE_LOOP);
    for (int i = 0; i < nSegs; i++)
    {
      float sinth = sinf(k * i);
      float costh = cosf(k * i);

      glVertex2f(costh, sinth);
    }
    glEnd();
  } glPopMatrix();
}

inline void
glBoxf(float left, float right, float top, float bottom, bool fill=true)
{
  glBegin(fill ? GL_QUADS : GL_LINE_LOOP);
    glVertex2f(left, bottom);
    glVertex2f(right, bottom);
    glVertex2f(right, top);
    glVertex2f(left, top);
  glEnd();
}

inline void
glBoxf(const BBox2f& box, bool fill=true)
{
  glBoxf(box.bmin[0], box.bmax[0], box.bmin[1], box.bmax[1], fill);
}

#endif // __GL_SHAPES_H__
