#ifndef __SIFTER_H__
#define __SIFTER_H__

#include <third_party/sift/imgfeatures.h>

#include <cv.h>

// Feature extractor.  Even though it's called "Sifter", it may actually
// extract features in some other way.  For now, this doesn't do much but
// wrap the third_party sift library.
class Sifter {
  public:
    struct Feature {
      int id;
      float x, y;
      float descr[FEATURE_MAX_D];

      bool operator<(const Feature& other) const { return id <= other.id; }
    };

    struct Image {
      cv::Mat m;
      std::vector<Feature> features;
    };

    void ExtractFeatures(Image& img);
  private:
};

#endif //__SIFTER_H__

