#include "sifter.h"

extern "C" {
#include <third_party/sift/sift.h>
#include <third_party/sift/imgfeatures.h>
}

using namespace cv;


void
Sifter::ExtractFeatures(Image& img)
{
  Mat copy = img.m.clone();
  IplImage iplImg(copy);
  struct feature* sift_feat;
  int numFeatures = sift_features(&iplImg, &sift_feat);

  int featureId = 0;
  img.features.clear();
  img.features.resize(numFeatures);
  for (int i = 0; i < numFeatures; i++) {
    Feature& f = img.features[i];
    f.id = featureId++;
    f.x = sift_feat[i].img_pt.x;
    f.y = sift_feat[i].img_pt.y;

    for (int d = 0; d < sift_feat[i].d; d++) {
      f.descr[d] = sift_feat[i].descr[d];
    }
  }

  free (sift_feat);
}

