#ifndef __MATCHER_H__
#define __MATCHER_H__

#include "sifter.h"

#include <cv.h>
#include <set>
#include <utility>
#include <vector>

class Matcher {
  public:
    struct MatchTuple {
      int first, second;
      float distance;
      bool matched;
    };

    typedef std::vector<MatchTuple> Matches; 

    void SetPrimary(const Sifter::Image& img);
    void SetPrimary(const Sifter::Image& img, const std::set<int>& featureIds);

    Matches GetCorrespondence(const Sifter::Image& other) const;
    cv::Mat ComputeXform(const Sifter::Image& other, Matches& matches, float threshhold, bool useRansac=true,  float ransacThreshhold=2.f) const;
    void Warp(Sifter::Image& dest, const Sifter::Image& src, const cv::Mat& xform) const;

  private:
    std::vector<Sifter::Feature> _features;
    cv::Mat _queryMatrix; 
};

#endif // __MATCHER_H__
