#ifndef __FLOW_H__
#define __FLOW_H__

#include "graph.h"

#include <map>
#include <vector>

class FlowSolver {
  public:
    FlowSolver(const Graph& g, int source, int sink);

    std::vector<int> MinCut();
  private:

    // graph structs for residual graph
    struct ResVertex {
      ResVertex() : visited(false) { }
      std::vector<int> outEdgeIndices;
      bool visited;
    };

    struct ResEdge {
      int start, end;
      int capacity;

      int orig_capacity;
    };

    struct EdgePath {
      //EdgePath() : cost(0) { }
      //int cost;
      std::vector<int> indices;
      //bool operator<(const EdgePath& other) { return cost < other.cost; }
    };

    EdgePath FindAugmentingPath() const;

    int GetPathCapacity(const EdgePath& path) const;

    void UpdateFlow(const EdgePath& path, int capacity);

    int _source, _sink;
    std::vector<ResVertex> _resV;
    std::vector<ResEdge> _resE;
    size_t _newEdgeBegin;
    std::map<std::pair<int, int>, int> _toEdge;

    void DebugPrintState() const;
};

#endif // __FLOW_H__
